﻿/*	VERSION:  1.0

DESCRIPTION:
	This creates a new function which calls another function with a pre-defined set of parameters.
	It's useful for promise chains,  but the result of the promise cannot be accessed by pre-applied functions since they ignore all new parameters passed to them when called
	
	myPromise
	.then( step1,  error )
	.then( preApply( step2,param1,param2 ),  error )
	.then( step3,  error )
	.then( done, error );
*/
function preApply( func ){
	// ignore the "func", and remember the rest of the passed parameters
	var params = arguments.slice(1);
	// run the specified function with all of the remaining parameters
	var runThis = function(){
		func.apply( this, params );
	}// runThis()
	return runThis;
}// preApply()